﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;

namespace AZVIC.Ei8htPOS.Entities
{
    public class PromoCodes : BusinessBaseClass
    {

        public PromoCodes()
        {

        }

        public PromoCodes(IDataReader myDataRecord)
        {
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PromoCodeID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("PromoCodeID"));
            PromoType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PromoType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("PromoType"));
            PromoCode = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PromoCode")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("PromoCode"));
            DiscountType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DiscountType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("DiscountType"));
            Discount = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Discount")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("Discount"));
            StartDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("StartDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            EndDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("EndDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("EndDate"));
            PriceRangeFrom = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PriceRangeFrom")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("PriceRangeFrom"));
            PriceRangeTo = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PriceRangeTo")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("PriceRangeTo"));
            UseFromPrice = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("UseFromPrice")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("UseFromPrice"));
            MaxUsage = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("MaxUsage")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("MaxUsage"));
            AvailableUsage = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("AvailableUsage")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("AvailableUsage"));
            UserAccountID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            //IsDeleted = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsDeleted")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsDeleted"));
        }

        [DataObjectField(true, false, false)]
        public override Guid UniqueID { get; set; }

        public string PromoType { get; set; }

        public string PromoCode { get; set; }

        public string DiscountType { get; set; }

        public decimal Discount { get; set; }

        public DateTime StartDate { get; set; }

        public DateTime EndDate { get; set; }

        public decimal PriceRangeFrom { get; set; }

        public decimal PriceRangeTo { get; set; }

        public bool UseFromPrice { get; set; }

        public int MaxUsage { get; set; }

        public int AvailableUsage { get; set; }

        public Guid UserAccountID { get; set; }

        public override DateTime CreatedDate { get; set; }

        public override DateTime ModifiedDate { get; set; }

        public override GlobalConfigurations.Mode Mode { get; set; }

        public override bool IsActive { get; set; }
    }
}
